// AlifeDoc.cpp : implementation of the CAlifeDoc class
//

#include "stdafx.h"
#include "Alife.h"
//My includes
#include "AlifeDoc.h"
#include "MainFrm.h" //For CMainFrame class
#include "random.h" //For rrRandomreal()
#include <math.h> //for cos and sin

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAlifeDoc

IMPLEMENT_DYNCREATE(CAlifeDoc, CDocument)

BEGIN_MESSAGE_MAP(CAlifeDoc, CDocument)
	//{{AFX_MSG_MAP(CAlifeDoc)
	ON_COMMAND(ID_FILE_LOADBACKGROUND, OnFileLoadbackground)
	ON_COMMAND(ID_FILE_SAVESCREENBITMAP, OnFileSavescreenbitmap)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//My functions

#define MAGNETS_COUNT 8

void CAlifeDoc::setDemoType(UINT new_demotype)
{
	int i, j, modulus;
	Critter *critter;
	CMainFrame *mainwnd = (CMainFrame*)AfxGetMainWnd();

	_demotype = new_demotype;
	if (_critterlist)
	{
		delete _critterlist;
		_critterlist = NULL;
	}
	_critterlist = new OwnerCritterList();
	switch (_demotype)
	{
		case DEM_MIXED:
			_crittercount = 14; //One Sun, One gnarly, 3 UFO, 3 earth,
				// 3 bum, 3 spring
 			for (i=0; i< _crittercount; i++)
			{
				if (i == 0)
				{
					critter = new CursorCritter();
					critter->SetCursorMoveResponse(0.1);
					critter->SetIcon(mainwnd->_pMemDC_sun);
				} //end of i == 0 case
				else if (i == _crittercount - 1)
			  	{
			  		critter = new SpringGravityCritter();
			  		critter->SetIcon(mainwnd->_pMemDC_gnarly);
			  		for (j=0; j<i; j++)
			  			critter->Add((*_critterlist)[j]);
			  	} //end of i == critter-1 case
				else // 0 < i < _crittercount - 1
				{
					modulus = (i-1)%4;
					switch(modulus)
					{
						case 0:
							critter = new GravityCritter();
							critter->SetGravityConstant(rrRandomreal(5.0,100.0));
							critter->SetIcon(mainwnd->_pMemDC_earth);
							critter->Add((*_critterlist)[0]);
							break;
						case 1:
							critter = new SpringCritter();
							critter->SetIcon(mainwnd->_pMemDC_spring);
							critter->SetSpringConstant(rrRandomreal(30.0, 100.0));
							critter->Add((*_critterlist)[i-1]);
							break;
						case 2:
							critter = new WanderCritter();
							critter->SetIcon(mainwnd->_pMemDC_bum);
							break;
						case 3:
							critter = new SpringGravityCritter();
							critter->SetGravityConstant(-rrRandomreal(3.0,30.0));
							critter->SetSpringConstant(rrRandomreal(3.0,30.0));
							critter->SetIcon(mainwnd->_pMemDC_ufo);
							critter->Add((*_critterlist)[i-1]);
							break;
					}  //end of switch on modulus
				} // End of case 0 < i < critter-1
				_critterlist->Add(critter);
 			} //End of i loop
			_world.Set_wrapflag(TRUE);
			break;
		case DEM_GRAVITY:
			_crittercount = 12;
 			for (i=0; i<3; i++)
			{
				critter = new FixedCritter();
				critter->SetIcon(mainwnd->_pMemDC_sun);
				_critterlist->Add(critter);
			}
			for (i=3; i< _crittercount; i++)
			{
				critter = new GravityCritter();
				critter->SetGravityConstant(rrRandomreal(3.0,30.0));
				critter->SetIcon(mainwnd->_pMemDC_earth);
				for (j=0; j<(3); j++)
		 			critter->Add((*_critterlist)[j]);
				_critterlist->Add(critter);
			}
			_world.Set_wrapflag(TRUE);
			break;
		case DEM_PEND_MAG:
			_crittercount = 2 + MAGNETS_COUNT; //5 magnets, one bob, one centerpull
 			for (i=0; i< _crittercount; i++)
			{
				if (i == 0)
				{
					critter = new CursorCritter();
					critter->SetCursorMoveResponse(0.6);
					critter->SetIcon(mainwnd->_pMemDC_sun);
				}
				else if (i < _crittercount - 1)
				{
					critter = new FixedCritter();
					critter->SetIcon(mainwnd->_pMemDC_earth);
				}
				else //_crittercount - 1
				{
					critter = new SpringGravityCritter();
					critter->SetIcon(mainwnd->_pMemDC_ufo);
		 			critter->AddSpring((*_critterlist)[0]);
					for (j=1; j<(_crittercount - 1); j++)
			 			critter->AddGravity((*_critterlist)[j]);
					critter->SetSpringConstant(200.0);
					critter->SetGravityConstant(-200.0);
					critter->SetMaxSpeed(30.0);
				}
				_critterlist->Add(critter);
 			}
			_world.Set_wrapflag(FALSE);
			break;
		case DEM_CHASE:
		default:
			_crittercount = 24;
 			for (i=0; i< _crittercount; i++)
			{
				critter = new PredatorPreyCritter();
				_critterlist->Add(critter);
			}
 			for (i=0; i< _crittercount/3; i++)
			{
				 (*_critterlist)[i]->SetIcon(mainwnd->_pMemDC_earth);
	 			for (j=_crittercount/3; j< 2*_crittercount/3; j++)  //Flee UFOs
					(*_critterlist)[i]->AddPredator((*_critterlist)[j]);
	 			for (j=2*_crittercount/3; j< _crittercount; j++)  //Chase SUNs
					(*_critterlist)[i]->AddPrey((*_critterlist)[j]);
			}
 			for (i=_crittercount/3; i< 2*_crittercount/3; i++)
			{
				 (*_critterlist)[i]->SetIcon(mainwnd->_pMemDC_ufo);
	 			for (j=2*_crittercount/3; j< _crittercount; j++)  //Flee SUNs
					(*_critterlist)[i]->AddPredator((*_critterlist)[j]);
	 			for (j=0; j< _crittercount/3; j++) //Chase EARTHs
					(*_critterlist)[i]->AddPrey((*_critterlist)[j]);
			}
 			for (i=2*_crittercount/3; i< _crittercount; i++)
			{
				 (*_critterlist)[i]->SetIcon(mainwnd->_pMemDC_sun);
	 			for (j=0; j< _crittercount/3; j++)  //Flee EARTHs
					(*_critterlist)[i]->AddPredator((*_critterlist)[j]);
	 			for (j= _crittercount/3; j< 2*_crittercount/3; j++)  //Chase UFOs
					(*_critterlist)[i]->AddPrey((*_critterlist)[j]);
			}
			_world.Set_wrapflag(FALSE);
			break;
		case DEM_HOMEWORK:
			_crittercount = 13;
			critter = new CursorCritter();
			critter->SetCursorMoveResponse(1.0);
			critter->SetIcon(mainwnd->_pMemDC_face);
			_critterlist->Add(critter);
 			for (i=1; i< _crittercount; i++)
			{
				critter = new PredatorPreyCritter();
				_critterlist->Add(critter);
			}
 			for (i=1; i< _crittercount/2; i++)
			{
				(*_critterlist)[i]->SetIcon(mainwnd->_pMemDC_earth);
				(*_critterlist)[i]->AddPredator((*_critterlist)[0]);
				_critterlist->setValue(0, i, PREY_VALUE);
			}
 			for (i=_crittercount/2; i< _crittercount; i++)
			{
				(*_critterlist)[i]->SetIcon(mainwnd->_pMemDC_ufo);
				(*_critterlist)[i]->AddPrey((*_critterlist)[0]);
				_critterlist->setValue(0, i, PREDATOR_VALUE);
			}
 			_world.Set_wrapflag(TRUE);
			break;
	} //end of _demotype switch
	_critterlist->SetWorld(&_world);
	_critterlist->RandomizePositionVelocity();
	_critterlist->SetFocusCritter((*_critterlist)[0]);
	if (_demotype == DEM_PEND_MAG)
	{
		Real radius = 1.0;
		Real angle = 0.0;
		Real step = (2.0*PI)/(_critterlist->size()-2);
		for (i=1; i<_critterlist->size(); i++)
		{
			angle = (i-1)*step;
			(*_critterlist)[i]->SetPosition(
				Vector2(radius*cos(angle),radius*sin(angle)));
		}
	}
}
void CAlifeDoc::update()
{
	if (!_critterlist)
		return;
	if (!_animate_flag)
		return;
#ifdef UPDATE_NORMALIZE //Normalize all the directions
	_critterlist->updateAndNormalizeMetric();
#else
	_critterlist->updateMetric();
#endif
	_critterlist->Collide();
	_critterlist->Move();
	_critterlist->world()->updateTimeAdjuster();
	/*Make a fresh copy of the
	background image and then write animats on top of it. */
#define SHRINK_BACKGROUND
#ifndef SHRINK_BACKGROUND
	_pMemDC_background->copyTo(_pMemDC);  //Keep background fullscreen size
#else //SHRINK_BACKGROUND
	CRect rect(0, 0, _frame.maxx()+1, _frame.maxy()+1);
	_pMemDC_background->stretchTo(_pMemDC, &rect); 
#endif //SRINK_BACKGROUND
	_critterlist->Show(_pMemDC, _frame);
	UpdateAllViews(NULL); //NULL means all views
}


/////////////////////////////////////////////////////////////////////////////
// CAlifeDoc construction/destruction

CAlifeDoc::CAlifeDoc():
_demotype(STARTDEMOTYPE),
_animate_flag(TRUE),
_crittercount(0),
_critterlist(NULL),
_world(Box2(-4.0, -3.0, 4.0, 3.0), 0.0, 0.2, FALSE)
//clipbox, dt, runspeed, wrapflag
{
	// My Code		
	_pMemDC =  new cMemoryDC(CMEMDC_FULLSCREEN);
	_pMemDC_background =  new cMemoryDC(CMEMDC_FULLSCREEN);
/*		We can load a background bitmap from a resource or from a file.
	The default _resize_on_load cMemoryDC flag value of FALSE means stretch the file
or resource bitmap to fit the _pMemDC. 
	If we do it from a file we would have a line like this:
		_pMemDC_background->loadFileBitmap("alife.bmp"); 
	If you use loadFileBitmap, the file name must include	path information.  An easy out 
is to assume it lives in the same dir as the executable. Note that when you are doing
DEBUG or RELEASE builds, your *.EXE will be in a subdir which won't have alife.bmp in it
unless you have put it there.
	This is all a lot of trouble, so its easier to make an alife.bmp, put it in the
\RES subdirectory, then use the resource editor to add a bitmap resource which is an
"import" and use the alife.bmp and give it a resource identifier like IDB_ALIFE. */
//	_pMemDC_background->loadResourceBitmap(IDB_RECT256); 
	_frame.SetRealWindow(_world.box().lox(), _world.box().loy(),
		 _world.box().hix(), _world.box().hiy());
	setDemoType(_demotype);
	_world.Set_cursorvector(Vector2(0.0, 0.0));
	_world.Set_wrapflag(TRUE);
}

CAlifeDoc::~CAlifeDoc()
{
	delete _pMemDC;
	delete _pMemDC_background;
	if (_critterlist)
		delete _critterlist;
}

BOOL CAlifeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CAlifeDoc serialization

void CAlifeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here

	}
}

/////////////////////////////////////////////////////////////////////////////
// CAlifeDoc diagnostics

#ifdef _DEBUG
void CAlifeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAlifeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAlifeDoc commands
#define MAXFILENAME 256
// Maximum length of file with pathname

void CAlifeDoc::OnFileLoadbackground() 
{
	OPENFILENAME ofn;
	char szFilterSpecBMP [128] =
		"BMP Files (*.BMP)\0All Files (*.*)\0*.*\0";
	char szFileName[MAXFILENAME];
	char szFileTitle[MAXFILENAME];

	lstrcpy(szFileName,"*.BMP");
	// fill in non-variant fields of OPENFILENAME struct.
	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner	  = AfxGetMainWnd()->m_hWnd;
	ofn.lpstrFilter	  = szFilterSpecBMP;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter	  = 0;
	ofn.nFilterIndex	  = 1;
	ofn.lpstrFile         = szFileName;
	ofn.nMaxFile	  = MAXFILENAME;
	ofn.lpstrInitialDir   = NULL;
	ofn.lpstrFileTitle    = szFileTitle;
	ofn.nMaxFileTitle     = MAXFILENAME;
	ofn.lpstrTitle        = NULL;
	ofn.lpstrDefExt       = "BMP";
	ofn.Flags             = 0;
	if( ::GetOpenFileName((LPOPENFILENAME)&ofn) )
	{
		::SetCursor(::LoadCursor(NULL, IDC_WAIT)); // Wait, I'm working!
		_pMemDC_background->loadFileBitmap(szFileName);
		::SetCursor(::LoadCursor(NULL, IDC_ARROW)); //I'm done!
	}
}

void CAlifeDoc::OnFileSavescreenbitmap() 
{
	OPENFILENAME ofn;
	char szFilterSpecBMP [128] =
		"BMP Files (*.BMP)\0All Files (*.*)\0*.*\0";
	char szFileName[MAXFILENAME];
	char szFileTitle[MAXFILENAME];
		
	lstrcpy(szFileName,"*.BMP");
	/* fill in non-variant fields of OPENFILENAME struct. */
	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner	  = AfxGetMainWnd()->m_hWnd;
	ofn.lpstrFilter	  = szFilterSpecBMP;
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter	  = 0;
	ofn.nFilterIndex	  = 1;
	ofn.lpstrFile         = szFileName;
	ofn.nMaxFile	  = MAXFILENAME;
	ofn.lpstrInitialDir   = NULL;
	ofn.lpstrFileTitle    = szFileTitle;
	ofn.nMaxFileTitle     = MAXFILENAME;
	ofn.lpstrTitle        = NULL;
	ofn.lpstrDefExt       = "BMP";
	ofn.Flags             = 0;
	if( ::GetSaveFileName((LPOPENFILENAME)&ofn) )
	{
		::SetCursor(LoadCursor(NULL, IDC_WAIT)); // Wait, I'm working!
		//Assume you want the critters too
		_pMemDC->saveFileBitmap(szFileName);
		::SetCursor(LoadCursor(NULL, IDC_ARROW)); //I'm done!
	}
}
